package app.firezone.synk.network.Adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.ItemWinnerLayoutBinding;
import app.firezone.synk.network.model.Winner_Model;

import java.util.ArrayList;

public class TopWinnerAdapter extends RecyclerView.Adapter<TopWinnerAdapter.holder> {
    Context mContext;
    ArrayList<Winner_Model> mlist;

    public TopWinnerAdapter(ArrayList<Winner_Model> mlist, Context mContext){
        this.mlist = mlist;
        this.mContext = mContext;

    }

    @NonNull
    @Override
    public holder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(mContext).inflate(R.layout.item_winner_layout,parent,false);
        return new holder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull holder holder, @SuppressLint("RecyclerView") int position) {

        Winner_Model model = mlist.get(position);


        holder.binding.winnerName.setText(model.getUsername());
        holder.binding.winnerPrize.setText("₹" +model.getPrize());

    }

    @Override
    public int getItemCount() {
        return mlist.size();
    }

    public class holder extends RecyclerView.ViewHolder {

        ItemWinnerLayoutBinding binding;

        public holder(@NonNull View itemView) {
            super(itemView);
            binding = ItemWinnerLayoutBinding.bind(itemView);
        }
    }
}
